/****
 * CSourceDocument.h
 *
 *	Source Document Class for GW Ada.
 *

	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.

 ****/

#define	_H_CSourceDocument			/* Include this file only once */
#include "CTextDocument.h"
#include <CApplication.h>  
#include "MacAdaMrgp.h"
#include <AppleEvents.h>
#include <Aliases.h>

CLASS CListingDocument;	
struct CSourceDocument : CTextDocument {
protected:
		CListingDocument	*itsListing;	// listing belonging to this source
		Boolean				fCompilingOnly;	// opened only during compilation
		Msg 				*fErrorMsgs;
		long				fNumErrors;

public:

						/** Construction/Destruction **/
  			void        ISourceDocument(CApplication *aSupervisor,
  								Boolean compile);

	virtual Boolean		Close(Boolean quitting);
	virtual	void		DoRevert(void);
	virtual	void		MakeWindow(void);

	virtual void		DoCommand(long theCommand);
	virtual void		UpdateMenus(void);

	// Specialized behaviour
	
			void		CreateListing(Str255 name);
			void		OpenListing(void);
			void		ConnectListing(CListingDocument *list);
			void		ListingClosed(void);

			long		GetNumErrors(void);
			Msg			*GetErrorMsgs(void);

			Boolean		IsItCompileOnly(void);

protected:
			OSErr		SendODOC(AEAddressDesc *targetAddress,AliasHandle targetFile);
			void		AEOpenListing(FSSpec fileSpec);
};
